
import numpy as np

def generate_multivariate_gaussian_samples(n_samples, n_dim, rho):
    # Define the correlation matrix
    correlation_matrix = np.eye(n_dim) * rho
    
    # Define the covariance matrix for the joint distribution of (Xa, Xb)
    covariance_matrix = np.block([
        [np.eye(n_dim), correlation_matrix],
        [correlation_matrix, np.eye(n_dim)]
    ])
    
    # Generate samples from a multivariate Gaussian distribution
    mean = np.zeros(2 * n_dim)
    samples = np.random.multivariate_normal(mean, covariance_matrix, n_samples)
    
    # Split the samples into Xa and Xb
    Xa = samples[:, :n_dim]
    Xb = samples[:, n_dim:]
    
    return Xa, Xb

# Parameters
n_samples = 1000  # Number of samples to generate
n_dim = 30         # Dimensionality of Xa and Xb
rho = 0.5         # Correlation coefficient

# Generate samples
Xa, Xb = generate_multivariate_gaussian_samples(n_samples, n_dim, rho)
